<?php

if ( ! defined( 'ABSPATH' ) ) exit;

require_once wp_elementor . '/elementor/traits.php';

class gmaakeup_Elementor_Integration {

	public $widgets;

	public function __construct()
	{
		$this->widgets = [
            
        'header',
        'footer',
        'header-slider',        
        'features',
        'about',         
        'our-plans',       
        'service', 
        'service-one', 
        'portfolio', 
        'counter',  
        'testimonial',   
        'blog', 
        'price',
        'faq',  
        'brand', 
        'contact-sections',       
        'contact-info',       
                
		];
		add_action( 'elementor/init', array( $this, 'widgets_registered' ) );
	}
	public function widgets_registered()
	{
		if ( ! defined( 'ELEMENTOR_PATH' ) || ! class_exists( 'Elementor\Widget_Base' ) || ! class_exists( 'Elementor\Plugin' ) ) {
			return false;
		}

		$elementor = Elementor\Plugin::instance();


		foreach ($this->widgets as $widget) {
			$template_file = wp_elementor . "/elementor/widgets/{$widget}.php";
			if ( file_exists( $template_file ) ) {
				require_once $template_file;
			}
		}
	}
}
new gmaakeup_Elementor_Integration;