<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Elementor_Contact_Info extends Widget_Base {

	public function get_name() {
		return 'Elementor-contact-info';
	}

	public function get_title() {
		return __( 'Zc >  Contact Info' ,'gmaakeup' );
	}

	public function get_icon() {
		
		return 'eicon-icon-box';
	}

	protected function _register_controls() {
		$traits = new \gmaakeup_Elementor_Traits($this);
		
		$this->start_controls_section(
			'services_section',
			['label' => esc_html__( 'Contact Info','gmaakeup'),]
		);
        
        $this->add_control(

			'text_heading',
                [

                    'label' => esc_html__( 'Heading' ,'gmaakeup'),
                    'type' => Controls_Manager::TEXT,
                ]
			);
        $this->add_control(

			'shortcode',
                [

                    'label' => esc_html__( 'Contact Form' ,'gmaakeup'),
                    'type' => Controls_Manager::TEXTAREA,
                ]
			);
		$this->add_control(
			'service_section',
			[
				'label' => esc_html__( 'Repeator Text','gmaakeup'),
				'type' => Controls_Manager::REPEATER,
				'fields' => [
					
					[                    
						'name' => 'icon',
						'label' => esc_html__( 'Icon' ,'gmaakeup' ),
						'type' => Controls_Manager::TEXT,
					],
                    
                    [                    
						'name' => 'text',
						'label' => esc_html__( 'Heading' ,'gmaakeup' ),
						'type' => Controls_Manager::TEXT,
					],
                    
                    [                    
						'name' => 'content',
						'label' => esc_html__( 'Content' ,'gmaakeup' ),
						'type' => Controls_Manager::TEXTAREA,
					],
                              
				],
			]
		);
         
		$this->end_controls_section();
	}

	protected function render( $instance = [] ) {

		gmaakeup_el()->get_section('contact-info', [
            
			'service_section_var' => $this->get_settings('service_section'),
			'column_section_data' => $this->get_settings('column_section'),
            'text_heading' => $this->get_settings('text_heading'),
			'shortcode' => $this->get_settings('shortcode'),
          
			]);
	}

	protected function content_template() {}

	public function render_plain_content() {}

}

Plugin::instance()->widgets_manager->register_widget_type( new Elementor_Contact_Info() );