<?php
namespace Elementor;
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
class Elementor_Header_box extends Widget_Base {
public function get_name() {
return 'Elementor-Header-widget';
}
public function get_title() {
return __( 'Zc >  Header' ,'gmaakeup' );
}
public function get_icon() {
return 'eicon-slider-device';
}
protected function _register_controls() {
$traits = new \gmaakeup_Elementor_Traits($this);
$this->start_controls_section(
'section_tab', [
'label' =>esc_html__( 'Header', 'gmaakeup' ),
]
);
$this->add_control(
'style', [
'type'         => Controls_Manager::SELECT,
'label'         => esc_html__( 'Choose Style', 'gmaakeup' ),
'default'     => 'style1',
'label_block'     => true,
'options'     => [
'style1' =>esc_html__( 'Header Style 1', 'gmaakeup' ),
'style2' =>esc_html__( 'Header Style Video', 'gmaakeup' ),
'style3' =>esc_html__( 'Header Normal', 'gmaakeup' ),

],
]
);
$this->add_control(
'icon', [
'label'             =>esc_html__( 'Icon', 'gmaakeup' ),
'type'             => Controls_Manager::TEXT,
'condition'      => [
'style' =>['style5'],
],
]
);

$this->add_control(
        'header_background_color',
        [
            'label' => __( 'Background Color Overlay', 'gmaakeup' ),
            'type' => Controls_Manager::COLOR,
            'condition'      => [
                'style' =>['style2','style3'],
                ],
            'selectors' => [
                '{{WRAPPER}} .slider-bg2::before,.slider-bg3::before' => 'background-color: {{VALUE}};',
                '{{WRAPPER}} .slider-bg2 .slider-content.second-slider-content::before,.slider-bg2 .slider-content.second-slider-content::after' => 'border-color: {{VALUE}};',
            ],
        ]
    );
$this->add_control(
'header_backgrund_images', [
'label'             =>esc_html__( 'Header Video', 'gmaakeup' ),
'type'             => Controls_Manager::MEDIA,
'condition'      => [
'style' =>['style1','style3','style5'],
],
]
);
$this->add_control(
'background_text', [
'label'             =>esc_html__( 'Header Background Text', 'gmaakeup' ),
'type'             => Controls_Manager::TEXT,
'condition'      => [
'style' =>['style2'],
],
]
);    
$this->add_control(
'header_image', [
'label'             =>esc_html__( 'Header Image', 'gmaakeup' ),
'type'             => Controls_Manager::MEDIA,
'condition'      => [
'style' =>['style3'],
],
]
);
$this->add_control(
'header_images', [
'label'             =>esc_html__( 'Header Images', 'gmaakeup' ),
'type'             => Controls_Manager::MEDIA,
'condition'      => [
'style' =>['style2'],
],
]
);
$this->add_control(
'header_video', [
'label'             =>esc_html__( 'Choose File Video', 'gmaakeup' ),
'type'             => Controls_Manager::MEDIA,
'condition'      => [
'style' =>['style2'],
],
]
);
$this->add_control(
'title_text', [
'label'             =>esc_html__( 'Heading ', 'gmaakeup' ),
'type'             => Controls_Manager::TEXT,
'label_block'     => true,
'placeholder'     =>esc_html__( 'Featured Products', 'gmaakeup' ),
'default'         =>esc_html__( 'Featured', 'gmaakeup' ),
]
);
$this->add_control(
'sub_title', [
'label'             =>esc_html__( 'Heading Sub Title', 'gmaakeup' ),
'type'             => Controls_Manager::TEXTAREA,
'label_block'     => true,
'placeholder'     =>esc_html__( 'gmaakeup Text', 'gmaakeup' ),
'default'         =>esc_html__( 'gmaakeup', 'gmaakeup' ),
'condition'      => [
'style' =>['style1','style3'],
],
]
);
$this->add_control(
'desc_title', [
'label'             =>esc_html__( 'Description', 'gmaakeup' ),
'type'             => Controls_Manager::TEXTAREA,
'label_block'     => true,
'placeholder'     =>esc_html__( 'gmaakeup Text', 'gmaakeup' ),
'default'         =>esc_html__( 'gmaakeup', 'gmaakeup' ),
'condition'      => [
'style' => ['style2','style3']
],
]
);
$this->add_control(
'slider_button', [
'label'             =>esc_html__( 'Slider Button Text', 'gmaakeup' ),
'type'             => Controls_Manager::TEXTAREA,
'label_block'     => true,
'placeholder'     =>esc_html__( 'gmaakeup Text', 'gmaakeup' ),
'default'         =>esc_html__( 'Read More', 'gmaakeup' ),
'condition'      => [
'style' => ['style2']
],
]
);
$this->add_control(
'button_text', [
'label'             =>esc_html__( 'Button Text', 'gmaakeup' ),
'type'             => Controls_Manager::TEXT,
'condition'      => [
'style' =>[ 'style1'],
],
]
);
$this->add_control(
'button_link', [
'label'             =>esc_html__( 'Button URL', 'gmaakeup' ),
'type'             => Controls_Manager::URL,
'condition'      => [
'style' => ['style1'],
],
]
);
$this->add_control(
'button_text_contact', [
'label'             =>esc_html__( 'Button Text Video', 'gmaakeup' ),
'type'             => Controls_Manager::TEXT,
'condition'      => [
'style' =>['style2','style2'],
],
]
); 
$this->add_control(
'button_link_contact', [
'label'             =>esc_html__( 'Button URL Video', 'gmaakeup' ),
'type'             => Controls_Manager::URL,
'condition'      => [
'style' => ['style1','style2'],
],
]
);

$this->add_control(
'shortcode',
[
'label' => __( 'Enter your shortcode', 'gmaakeup' ),
'type' => Controls_Manager::TEXTAREA,
'dynamic' => [
'active' => true,
],
'placeholder' => '[gallery id="123" size="medium"]',
'default' => '',
'condition'      => [
'style' => ['style3']
],
]
);
$this->add_responsive_control(
'title_align', [
'label'             =>esc_html__( 'Alignment', 'gmaakeup' ),
'type'             => Controls_Manager::CHOOSE,
'options'         => [
'left'         => [
'title'     =>esc_html__( 'Left', 'gmaakeup' ),
'icon'     => 'fa fa-align-left',
],
'center'     => [
'title'     =>esc_html__( 'Center', 'gmaakeup' ),
'icon'     => 'fa fa-align-center',
],
'right'         => [
'title'     =>esc_html__( 'Right', 'gmaakeup' ),
'icon'     => 'fa fa-align-right',
],
'justify'     => [
'title'     =>esc_html__( 'Justified', 'gmaakeup' ),
'icon'     => 'fa fa-align-justify',
],
],
'default'         => '',
'selectors' => [
'{{WRAPPER}} .inner-item' => 'text-align: {{VALUE}};',
],
]
);
$this->end_controls_section();
}
protected function render( $instance = [] ) {
$settings = $this->get_settings();
$style = $settings[ 'style' ];
$title_text = $settings[ 'title_text' ];
$sub_title = $settings[ 'sub_title' ];
$desc_title = $settings[ 'desc_title' ];
$slider_button = $settings[ 'slider_button' ];
$header_backgrund_images = $settings[ 'header_backgrund_images' ];
$background_text = $settings[ 'background_text' ];
$header_image = $settings[ 'header_image' ];
$header_images = $settings[ 'header_images' ];
$icon = $settings[ 'icon' ];
$button_text = $settings[ 'button_text' ];
$button_text_contact = $settings[ 'button_text_contact' ];
$button_link = $settings[ 'button_link' ];
$button_link_contact = $settings[ 'button_link_contact' ];
$shortcode = $settings[ 'shortcode' ];
$header_video = $settings[ 'header_video' ];

switch ( $style ) {
case 'style1':
require get_template_directory() . '/inc/sections/header/style1.php';
break;
case 'style2':
require get_template_directory() . '/inc/sections/header/style2.php';
break;
case 'style3':
require get_template_directory() . '/inc/sections/header/style3.php';
break;
}
}
protected function content_template() {}
public function render_plain_content() {}
}
Plugin::instance()->widgets_manager->register_widget_type( new Elementor_Header_box() );