<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Elementor_testimonial extends Widget_Base {

	public function get_name() {
		return 'Elementor-testimonial';
	}

	public function get_title() {
		return esc_html__( 'Zc >  Testimonial' ,'gmaakeup' );
	}

	public function get_icon() {
		
		return 'eicon-icon-box';
	}

	protected function _register_controls() {
		$traits = new \gmaakeup_Elementor_Traits($this);
		
		$this->start_controls_section(
			'services_section',
			['label' => esc_html__( 'Testimonials','gmaakeup'),]
		);
        
        
         $this->add_control(

            'back_img',

            [
                'label' => esc_html__( 'Background Image' ,'gmaakeup'),
                'type' => Controls_Manager::MEDIA,
            ]
            );
        
        $this->add_control(

            'icon_img',

            [
                'label' => esc_html__( 'Icon Image' ,'gmaakeup'),
                'type' => Controls_Manager::MEDIA,
            ]
            );
        
        $this->add_control(

            'text_heading',

            [
                'label' => esc_html__( 'Text Heading' ,'gmaakeup'),
                'type' => Controls_Manager::TEXT,
            ]
            );
            $this->add_control(

			'sub_heading',
			[
				'label' => esc_html__( 'Sub Heading' ,'gmaakeup'),
				'type' => Controls_Manager::TEXT,
			]
			);
         				
		$this->add_control(
			'service_section',
			[
				'label' => esc_html__( 'Repeator Text','gmaakeup'),
				'type' => Controls_Manager::REPEATER,
				'fields' => [
				   
                  [
						'name' => 'features_img',
						'label' => esc_html__( 'features Image','gmaakeup'),
						'type' => Controls_Manager::MEDIA,
					],
					
					[
					    'name' => 'features_img_switcher',
						'label' => esc_html__( 'features Image Switcher','gmaakeup'  ),
						'type' => Controls_Manager::SWITCHER,
						'default' => 'yes',
						'label_on' => esc_html__( 'Show','gmaakeup' ),
						'label_off' => esc_html__( 'Hide','gmaakeup'  ),
						'return_value' => 'yes',
					],
                    
                     [
						'name' => 'text',
						'label' => esc_html__( 'Text' ,'gmaakeup' ),
						'type' => Controls_Manager::TEXT,
					],
					
                    [
						'name' => 'name',
						'label' => esc_html__( 'name' ,'gmaakeup' ),
						'type' => Controls_Manager::TEXT,
					],
                    
                    [
						'name' => 'position',
						'label' => esc_html__( 'Position' ,'gmaakeup' ),
						'type' => Controls_Manager::TEXT,
					],
                    
                    [
						'name' => 'content',
						'label' => esc_html__( 'Content' ,'gmaakeup' ),
						'type' => Controls_Manager::TEXTAREA,
					],
                    
				],
			]
		);
         
		$this->end_controls_section();
		
	}

	protected function render( $instance = [] ) {

		gmaakeup_el()->get_section('testimonial', [
            
			'service_section_var' => $this->get_settings('service_section'), 
			'column_section_data' => $this->get_settings('column_section'),
			'hading_section_data' => $this->get_settings('heading-text'),
			'back_img' => $this->get_settings('back_img'),
			'icon_img' => $this->get_settings('icon_img'),
            'text_heading' => $this->get_settings('text_heading'),         
            'sub_heading' => $this->get_settings('sub_heading'),
          
			]);
	}

	protected function content_template() {}

	public function render_plain_content() {}

}

Plugin::instance()->widgets_manager->register_widget_type( new Elementor_testimonial() );