<?php
    /**
     * For full documentation, please visit: http://docs.reduxframework.com/
     * For a more extensive sample-config file, you may look at:
     * https://github.com/reduxframework/gmaakeup/blob/master/sample/sample-config.php
     */

    if ( ! class_exists( 'Redux' ) ) {
        return;
    }

    // This is your option name where all the Redux data is stored.
    $opt_name = "gmaakeup_data";


    $theme = wp_get_theme(); // For use with some settings. Not necessary.

    $args = array(
      'opt_name' => 'gmaakeup_data',
      'dev_mode' => false,
      'use_cdn' => true,
      'display_name' => $theme->get( 'Name' ),
      'display_version' => $theme->get( 'Version' ),
      'page_slug' => '_options',
      'page_title' => esc_html__('Theme Options', 'gmaakeup'),
      'admin_bar' => true,
      'menu_type' => 'menu',
      'menu_title' => esc_html__('Theme Options', 'gmaakeup'),
      'admin_bar_icon' => 'dashicons-admin-generic',
      'allow_sub_menu' => true,
      'page_parent_post_type' => 'your_post_type',
      'customizer' => true,
      'hints' => array(
        'icon'          => 'el el-question-sign',
        'icon_position' => 'right',
        'icon_size'     => 'normal',
        'tip_style'     => array(
          'color' => 'dark',
        ),
        'tip_position' => array(
          'my' => 'top left',
          'at' => 'bottom right',
        ),
        'tip_effect' => array(
          'show' => array(
            'duration' => '500',
            'event'    => 'mouseover',
          ),
          'hide' => array(
            'duration' => '500',
            'event'    => 'mouseleave unfocus',
          ),
        ),
      ),
      'output' => true,
      'output_tag' => true,
      'settings_api' => true,
      'cdn_check_time' => '1440',
      'compiler' => true,
      'page_permissions' => 'manage_options',
      'save_defaults' => true,
      'show_import_export' => true,
      'transient_time' => '3400',
      'network_sites' => true,
      'disable_tracking' => true,
    );

    Redux::setArgs( $opt_name, $args );

    /*
     * ---> END ARGUMENTS
     */


    /*
     *
     * ---> START SECTIONS
     *
     */

    // General Settings
    Redux::setSection( $opt_name, array(
      'title'  => esc_html__( 'General Settings', 'gmaakeup' ),
      'id'     => 'gmaakeup__section-general',
      'icon'   => 'el el-cogs',
      'fields' => array(
        array(
          'id'        => 'gmaakeup__opt-logo-standard',
          'type'      => 'media',
          'url'       => true,
          'title'     => esc_html__('Logo Image 1', 'gmaakeup'),
          'compiler'  => 'true',
          'desc'      => esc_html__('Upload your image or remove image', 'gmaakeup'),
          'default'   => array(
            'url'     => get_template_directory_uri() . '/inc/assets/images/logo.png'),
        ),
      )
    ) );
    

	// Header Right Menu

    Redux::setSection( $opt_name, array(
      'title'  => esc_html__( 'Header Right Menu', 'gmaakeup' ),
      'id'     => 'gmaakeup__subsection-right-menu',
      'subsection' => true,
      'fields' => array(
          array(
            'id'        => 'gmaakeup__opt-right-menu',
            'type'      => 'switch',
            'title'     => esc_html__('Switch', 'gmaakeup'),
			 'default'   => 2,
            'on'        => esc_html__( 'Yes', 'gmaakeup' ),
            'off'       => esc_html__( 'No', 'gmaakeup' ),
          ),

          array(
            'id'      => 'gmaakeup__right-menu',
            'type'    => 'textarea',
            'title'   => esc_html__( 'Right Menu Text', 'gmaakeup' ),
			'default'   => 1,
            'default' => ' <a href="contact.html" class="btn ss-btn">Get A Quote</a>',
            'required'  => array('gmaakeup__opt-right-menu', '=', '1'),
          ),
      )
        
        
    ) );


	 ///////////////////////////////////////////////////////// Theme color///////////////////////////////////////
    Redux::setSection( $opt_name, array(
      'title'  => esc_html__( 'Theme Colors', 'gmaakeup' ),
      'id'     => 'gmaakeup__section-color',
      'icon'   => 'el el-arrow-down',
      'fields' => array(
      )
    ) );

	Redux::setSection( $opt_name, array(
      'title'  => esc_html__( 'General Theme Colors', 'gmaakeup' ),
      'id'     => 'gmaakeup__subsection-general-theme-color',
	  'subsection' => true,
      'fields' => array(
	   array(
          'id'        => 'gmaakeup__opt-body-text-color',
          'type'      => 'color',
          'title'     => esc_html__('Body Text Color', 'gmaakeup'),
		   'default' => '#6e6e6e',
		  'output'  => array('body,.widget_categories a'),
		  'subtitle' => esc_html__('Theme Text Body Color Manage from the Redux Controller', 'gmaakeup'),
        ),
		 array(
			'id'       => 'opt-color-blog',
			'type'     => 'background',
			'output'   => array('.site-content'),
			'title'    => esc_html__('Page Background Color', 'gmaakeup'),
			'subtitle' => esc_html__('Pick a Page Background color for the theme', 'gmaakeup'),
            'default'  => array(
            'background-color'    => '#000',
          ),
		),
		 array(
			'id'       => 'opt-color-breadcums',
			'type'     => 'background',
			'output'  => array('.breadcrumb-area'),
			'title'    => esc_html__('Breadcums Background Color', 'gmaakeup'),
			'subtitle' => esc_html__('Pick a Breadcums background color for the theme', 'gmaakeup'),
			'default'               => array(
            'background-color'    => '#222',
			
          ),
		),
		array(
			'id'       => 'opt-color-footer',
			'type'     => 'background',
			'output'  => array('.footer-bg'),
			'title'    => esc_html__('Footer Background Color', 'gmaakeup'),
			'subtitle' => esc_html__('Pick a Footer background color for the theme', 'gmaakeup'),
			'default'               => array(
            'background-color'    => '#000',
          ),
		),
          
       array(
			'id'        => 'opt-color-bakground',
			'type'      => 'color',
			'title'     => esc_html__('Primary Color', 'gmaakeup'),
			'subtitle'  => esc_html__('Pick a background color.', 'gmaakeup'),
			'default'   => '#cc866c',
			'output'    => array(
				'background-color' => '.services-categories li a::after,.brochures-box .inner,.home-blog-active .slick-arrow:hover, .home-blog-active2 .slick-arrow:hover,.portfolio .col3 .grid-item .box a::after,.comment-form .submit,#scrollUp,.search-form .search-submit, .wp-block-search .wp-block-search__button,.top-btn,.widget-social a:hover,.comment-form .submit:hover,.services-08-item:hover .readmore,#scrollUp:hover,.gallery-image figcaption .span::before,.team-thumb .dropdown .xbtn,.blog-content2 .date-home,.f-cta-icon i,.contact-bg02 .btn.ss-btn.active',
				'color'            => '.header-cta ul li i,blockquote footer,.pricing-body li::before,.header-three .main-menu .sub-menu li a:hover, .menu .children li a:hover,.footer-link ul li a:hover,.comment-text .avatar-name span,.team-area-content span,.team-area-content li .icon i,.header-social a,a:hover,.services-08-thumb.glyph-icon i,.gallery-image figcaption .span,.team-info span,.team-info h4 a:hover,.single-team:hover .team-info h4,.testimonial-active .slick-arrow,.blog-btn a,.bsingle__post .video-p .video-i,.bsingle__content .meta-info ul li i,.about-content li .icon i',
				'border-color'     => '.post__tag ul li a:hover,.menu .children,.sidebar-widget .widgettitle,.tag-cloud-link:hover,.widget-social a:hover,.services-08-item:hover .readmore,.team-info .text,.blog-btn a,.contact-bg02 .btn.ss-btn.active'

			)
		),
          
        array(
			'id'        => 'opt-color-whtext',
			'type'      => 'color',
			'title'     => esc_html__('Primary White Text Color', 'gmaakeup'),
			'subtitle'  => esc_html__('Pick a White text color.', 'gmaakeup'),
			'default'   => '#fff',
			'output'    => array(
				
				'color'  => '.second-header a, .second-header span,.comment-form .submit,.search-form .search-submit,.wp-block-search .wp-block-search__button,.team-thumb .dropdown .xbtn,#scrollUp,.cta-title h2,.footer-widget .widgettitle, .footer-widget .cat-item, .footer-widget .widget ul li,.copyright-wrap .text,.f-cta-icon i,.btn-style-one'

			)
		),
        
        array(
			'id'        => 'opt-color-bg-black',
			'type'      => 'color',
			'title'     => esc_html__('Primary Black background Color', 'gmaakeup'),
			'subtitle'  => esc_html__('Pick a Black background color.', 'gmaakeup'),
			'default'   => '#232323',
			'output'    => array(
				
				'background-color'  => '.pricing-box.active .pricing-btn .btn,.copyright-wrap .text,.btn-style-one',

			)
		),
		
		
      )
    ) );
     //  Typography
    Redux::setSection( $opt_name, array(
      'title'  => esc_html__( 'Typography', 'gmaakeup' ),
      'id'     => 'gmaakeup__subsection-typography-general',
      'fields' => array(
	  
        
        array(
          'id'          => 'gmaakeup__custom_body_font',
          'type'        => 'switch',
          'title'       => esc_html__('Customize Body font?', 'gmaakeup'),
          'subtitle'    => esc_html__('Turn on to use custom fonts for the theme main text.', 'gmaakeup'),
          'default'     => false,
        ),
        array(
          'id'          => 'gmaakeup__body-font',
          'type'        => 'typography',
          'title'       => esc_html__('Body font', 'gmaakeup'),
          'subtitle'    => esc_html__('Specify the Body font properties.', 'gmaakeup'),
          'google'      => true,
          'output'      => array('body'),
          'units'       => 'px',
          'line-height' => false,
          'text-align'  => false,
          'required'    => array('gmaakeup__custom_body_font', '=', '1'),
          'default'     => array(
            'color'         => '#6e7b97',
            'font-size'     => '15px',
            'font-family'   => 'Roboto',
            'google'        => true,
            'font-weight'   => '400',
          ),
        ),
        array(
          'id'          => 'gmaakeup__custom_heading_font',
          'type'        => 'switch',
          'title'       => esc_html__('Customize Headings?', 'gmaakeup'),
          'subtitle'    => esc_html__('Turn on to use custom fonts, change color, line-height etc. for the theme Headings.', 'gmaakeup'),
          'default'     => false,
        ),
        array(
          'id'          => 'typography-h1',
          'type'        => 'typography',
          'title'       => esc_html__('H1 Heading', 'gmaakeup'),
          'subtitle'    => esc_html__('Specify the H1 heading font properties.', 'gmaakeup'),
          'google'      => true,
          'output'      => array('h1'),
          'units'       => 'px',
          'line-height' => false,
          'text-align'  => false,
          'required'    => array('gmaakeup__custom_heading_font', '=', '1'),
          'default'     => array(
            'color'         => '#002e5b',
            'font-size'     => '46px',
            'font-family'   => 'Roboto',
            'google'        => true,
            'font-weight'   => '600',
          ),
        ),
        array(
          'id'          => 'typography-h2',
          'type'        => 'typography',
          'title'       => esc_html__('H2 Heading', 'gmaakeup'),
          'subtitle'    => esc_html__('Specify the H2 heading font properties.', 'gmaakeup'),
          'google'      => true,
          'output'      => array('h2'),
          'units'       => 'px',
          'line-height' => false,
          'text-align'  => false,
          'required'    => array('gmaakeup__custom_heading_font', '=', '1'),
          'default'     => array(
            'color'         => '#002e5b',
            'font-size'     => '36px',
            'font-family'   => 'Roboto',
            'google'        => true,
            'font-weight'   => '600',
          ),
        ),
        array(
          'id'          => 'typography-h3',
          'type'        => 'typography',
          'title'       => esc_html__('H3 Heading', 'gmaakeup'),
          'subtitle'    => esc_html__('Specify the H3 heading font properties.', 'gmaakeup'),
          'google'      => true,
          'output'      => array('h3'),
          'units'       => 'px',
          'line-height' => false,
          'text-align'  => false,
          'required'    => array('gmaakeup__custom_heading_font', '=', '1'),
          'default'     => array(
            'color'         => '#002e5b',
            'font-size'     => '28px',
            'font-family'   => 'Roboto',
            'google'        => true,
            'font-weight'   => '600',
          ),
        ),
        array(
          'id'          => 'typography-h4',
          'type'        => 'typography',
          'title'       => esc_html__('H4 Heading', 'gmaakeup'),
          'subtitle'    => esc_html__('Specify the H4 heading font properties.', 'gmaakeup'),
          'google'      => true,
          'output'      => array('h4'),
          'units'       => 'px',
          'line-height' => false,
          'text-align'  => false,
          'required'    => array('gmaakeup__custom_heading_font', '=', '1'),
          'default'     => array(
            'color'         => '#002e5b',
            'font-size'     => '21px',
            'font-family'   => 'Roboto',
            'google'        => true,
            'font-weight'   => '600',
          ),
        ),
        array(
          'id'          => 'typography-h5',
          'type'        => 'typography',
          'title'       => esc_html__('H5 Heading', 'gmaakeup'),
          'subtitle'    => esc_html__('Specify the H5 heading font properties.', 'gmaakeup'),
          'google'      => true,
          'output'      => array('h5'),
          'units'       => 'px',
          'line-height' => false,
          'text-align'  => false,
          'required'    => array('gmaakeup__custom_heading_font', '=', '1'),
          'default'     => array(
            'color'         => '#002e5b',
            'font-size'     => '18px',
            'font-family'   => 'Roboto',
            'google' => true,
            'font-weight'   => '600',
          ),
        ),
        array(
          'id'          => 'typography-h6',
          'type'        => 'typography',
          'title'       => esc_html__('H6 Heading', 'gmaakeup'),
          'subtitle'    => esc_html__('Specify the H6 heading font properties.', 'gmaakeup'),
          'google'      => true,
          'output'      => array('h6'),
          'units'       => 'px',
          'line-height' => false,
          'text-align'  => false,
          'required'    => array('gmaakeup__custom_heading_font', '=', '1'),
          'default'     => array(
            'color'         => '#002e5b',
            'font-size'     => '15px',
            'font-family'   => 'Roboto',
            'google'        => true,
            'font-weight'   => '600',
          ),
        ),
      )
    ) );

	 /////////////////////////////////////////////////footer ///////////////////////////////////////////////
    Redux::setSection( $opt_name, array(
      'title'  => esc_html__( 'Theme Footer', 'gmaakeup' ),
      'id'     => 'gmaakeup__section-footer',
      'icon'   => 'el el-arrow-down',
      'fields' => array(
      )
    ) );
	

// Footer Text
    Redux::setSection( $opt_name, array(
      'title'  => esc_html__( 'Footer Text', 'gmaakeup' ),
      'id'     => 'gmaakeup__subsection-footer-text',
      'subsection' => true,
      'fields' => array(
          array(
            'id'        => 'gmaakeup__opt-footer-text',
            'type'      => 'switch',
            'title'     => esc_html__('Switch', 'gmaakeup'),
			'default'   => 2,
            'on'        => esc_html__( 'Yes', 'gmaakeup' ),
            'off'       => esc_html__( 'No', 'gmaakeup' ),
          ),
          
       )
    ) );


    // Footer Copyright
    Redux::setSection( $opt_name, array(
      'title'  => esc_html__( 'Copyright', 'gmaakeup' ),
      'id'     => 'gmaakeup__subsection-footer-copyright',
      'subsection' => true,
      'fields' => array(
          array(
            'id'        => 'gmaakeup__opt-copyright',
            'type'      => 'switch',
            'title'     => esc_html__('Switch', 'gmaakeup'),
			 'default'   => 2,
            'on'        => esc_html__( 'Yes', 'gmaakeup' ),
            'off'       => esc_html__( 'No', 'gmaakeup' ),
          ),
		
          array(
            'id'      => 'gmaakeup__copyright',
            'type'    => 'text',
            'title'   => esc_html__( 'Copyright Textarea', 'gmaakeup' ),
			'default'   => 1,
            'default' => '&copy; gmaakeup All design Zcube. .',
            'required'  => array('gmaakeup__opt-copyright', '=', '1'),
          ),
          
          array(
            'id'      => 'gmaakeup__location',
            'type'    => 'textarea',
            'title'   => esc_html__( 'Location Icons', 'gmaakeup' ),
			'default'   => 1,
            'default' => '&copy; gmaakeup All design Zcube. .',
            'required'  => array('gmaakeup__opt-copyright', '=', '1'),
          ),
      )
    ) );
	

    // Footer Widgets
    Redux::setSection( $opt_name, array(
      'title'  => esc_html__( 'Widgets', 'gmaakeup' ),
      'id'     => 'gmaakeup__subsection-footer-widgets',
	  'subsection' => true,
      'fields' => array(
        array(
          'id'        => 'gmaakeup__opt-footer-widgets',
          'type'      => 'switch',
          'title'     => esc_html__('Switch', 'gmaakeup'),
          'default'   => 2,
          'on'        => 'Show',
          'off'       => 'Hide',
        ),
        array(
          'id'        => 'gmaakeup__opt-footer-widgets-layout',
          'type'      => 'image_select',
          'compiler'  => true,
          'title'     => esc_html__('Footer Widgets Layout', 'gmaakeup'),
          'options'   => array(
            '1' => array(
              'alt' => esc_html__( '4 Columns (equal)', 'gmaakeup' ),
              'img' => get_template_directory_uri() . '/inc/admin/images/footer-cols2.png'),
            '2' => array(
              'alt' => esc_html__('4 Columns', 'gmaakeup'),
              'img' => get_template_directory_uri() . '/inc/admin/images/footer-cols1.png'),
            '3' => array(
              'alt' => esc_html__( '3 Columns (left wider)', 'gmaakeup' ),
              'img' => get_template_directory_uri() . '/inc/admin/images/footer-cols3.png'),
            '4' => array(
              'alt' => esc_html__( '3 Columns (right wider)', 'gmaakeup' ),
              'img' => get_template_directory_uri() . '/inc/admin/images/footer-cols4.png'),
            '5' => array(
              'alt' => esc_html__( '3 Columns (equal)', 'gmaakeup' ),
              'img' => get_template_directory_uri() . '/inc/admin/images/footer-cols5.png'),
            '6' => array(
              'alt' => esc_html__( '2 Columns (right wider)', 'gmaakeup' ),
              'img' => get_template_directory_uri() . '/inc/admin/images/footer-cols6.png'),
            '7' => array(
              'alt' => esc_html__( '2 Columns (left wider)', 'gmaakeup' ),
              'img' => get_template_directory_uri() . '/inc/admin/images/footer-cols7.png'),
          ),
          'default'   => '1',
          'required'  => array('gmaakeup__opt-footer-widgets', '=', '1'),
        ),
      )
    ) );
    
    /*
     * <--- END SECTIONS--->
     */