<?php
namespace Elementor;
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
class Elementor_About_Box extends Widget_Base {
public function get_name() {
return 'Elementor-About-widget';
}
public function get_title() {
return __( 'Zc >  About' ,'gmaakeup' );
}
public function get_icon() {
return 'eicon-slider-device';
}
protected function _register_controls() {
$traits = new \gmaakeup_Elementor_Traits($this);
$this->start_controls_section(
'section_tab', [
'label' =>esc_html__( 'About', 'gmaakeup' ),
]
);
$this->add_control(
'style', [
'type'         => Controls_Manager::SELECT,
'label'         => esc_html__( 'Choose Style', 'gmaakeup' ),
'default'     => 'style1',
'label_block'     => true,
'options'     => [
'style1' =>esc_html__( 'About Style 1', 'gmaakeup' ),
'style2' =>esc_html__( 'About Style 2', 'gmaakeup' ),
'style3' =>esc_html__( 'About Style 3', 'gmaakeup' ),
'style4' =>esc_html__( 'About Style 4', 'gmaakeup' ),
                  
],
]
);
$this->add_control(
'icon', [
'label'             =>esc_html__( 'Icon', 'gmaakeup' ),
'type'             => Controls_Manager::TEXT,
'condition'      => [
'style' =>['style5'],
],
]
);

$this->add_control(
			'header_background_color',
			[
				'label' => __( 'Background Color Overlay', 'gmaakeup' ),
				'type' => Controls_Manager::COLOR,
				'condition'      => [
					'style' =>['style2','style3'],
					],
				'selectors' => [
					'{{WRAPPER}} .slider-bg2::before,.slider-bg3::before' => 'background-color: {{VALUE}};',
					'{{WRAPPER}} .slider-bg2 .slider-content.second-slider-content::before,.slider-bg2 .slider-content.second-slider-content::after' => 'border-color: {{VALUE}};',
				],
			]
		);
		
		

$this->add_control(
'about_backgrund_images', [
'label'             =>esc_html__( 'Background Image', 'gmaakeup' ),
'type'             => Controls_Manager::MEDIA,
'condition'      => [
'style' =>['style3'],
],
]
);
$this->add_control(
'main_img', [
'label'             =>esc_html__( 'Main Image', 'gmaakeup' ),
'type'             => Controls_Manager::MEDIA,
'condition'      => [
'style' =>['style1','style2','style4'],
],
]
);
    
$this->add_control(
'icon_image', [
'label'             =>esc_html__( 'Icon Images', 'gmaakeup' ),
'type'             => Controls_Manager::MEDIA,
'condition'      => [
'style' =>['style2'],
],
]
);  
$this->add_control(
'text_heading', [
'label'             =>esc_html__( 'Text Heading', 'gmaakeup' ),
'type'             => Controls_Manager::TEXT,
'condition'      => [
'style' =>['style1','style2','style3','style4'],
],
]
);    
$this->add_control(
'sub_heading', [
'label'             =>esc_html__( 'Sub Heading', 'gmaakeup' ),
'type'             => Controls_Manager::TEXT,
'label_block'     => true,
'placeholder'     =>esc_html__( 'gmaakeup Text', 'gmaakeup' ),
'default'         =>esc_html__( 'gmaakeup', 'gmaakeup' ),
'condition'      => [
'style' =>['style1'],
],
]
);      

$this->add_control(
'header_video', [
'label'             =>esc_html__( 'Choose File Video', 'gmaakeup' ),
'type'             => Controls_Manager::MEDIA,
'condition'      => [
'style' =>['style5'],
],
]
);
$this->add_control(
'exp', [
'label'             =>esc_html__( 'Experience', 'gmaakeup' ),
'type'             => Controls_Manager::TEXTAREA    ,
'condition'      => [
'style' =>['style1'],
],
]
);        
$this->add_control(
'desc_title', [
'label'             =>esc_html__( 'Description', 'gmaakeup' ),
'type'             => Controls_Manager::TEXTAREA,
'label_block'     => true,
'placeholder'     =>esc_html__( 'gmaakeup Text', 'gmaakeup' ),
'default'         =>esc_html__( 'gmaakeup', 'gmaakeup' ),
'condition'      => [
'style' => ['style1','style2','style3','style4']
],
]
);
$this->add_control(
'desc_title1', [
'label'             =>esc_html__( 'Description 1', 'gmaakeup' ),
'type'             => Controls_Manager::TEXTAREA,
'label_block'     => true,
'placeholder'     =>esc_html__( 'gmaakeup Text', 'gmaakeup' ),
'default'         =>esc_html__( 'gmaakeup', 'gmaakeup' ),
'condition'      => [
'style' => ['style1','style2','style3']
],
]
);    
   
$this->add_control(
'slider_button', [
'label'             =>esc_html__( 'Slider Button Text', 'gmaakeup' ),
'type'             => Controls_Manager::TEXTAREA,
'label_block'     => true,
'placeholder'     =>esc_html__( 'gmaakeup Text', 'gmaakeup' ),
'default'         =>esc_html__( 'Read More', 'gmaakeup' ),
'condition'      => [
'style' => ['style5']
],
]
);
$this->add_control(
'button_text', [
'label'             =>esc_html__( 'Button Text', 'gmaakeup' ),
'type'             => Controls_Manager::TEXT,
'condition'      => [
'style' =>['style1'],
],
]
);
$this->add_control(
'button_link', [
'label'             =>esc_html__( 'Button URL', 'gmaakeup' ),
'type'             => Controls_Manager::URL,
'condition'      => [
'style' => ['style1'],
],
]
);
$this->add_control(
'button_text1', [
'label'             =>esc_html__( 'Button Text 1', 'gmaakeup' ),
'type'             => Controls_Manager::TEXT,
'condition'      => [
'style' =>['style5'],
],
]
);    
$this->add_control(
'button_link1', [
'label'             =>esc_html__( 'Button URL 1', 'gmaakeup' ),
'type'             => Controls_Manager::URL,
'condition'      => [
'style' => ['style5'],
],
]
);
$this->add_control(
'gal_img_one', [
'label'             =>esc_html__( 'Galler Image One', 'gmaakeup' ),
'type'             => Controls_Manager::MEDIA,
'condition'      => [
'style' =>['style5'],
],
]
);
    $this->add_control(
'gal_img_two', [
'label'             =>esc_html__( 'Galler Image Two', 'gmaakeup' ),
'type'             => Controls_Manager::MEDIA,
'condition'      => [
'style' =>['style5'],
],
]
);
$this->add_control(
'gal_img_three', [
'label'             =>esc_html__( 'Galler Image Three', 'gmaakeup' ),
'type'             => Controls_Manager::MEDIA,
'condition'      => [
'style' =>['style5'],
],
]
);
$this->add_control(
'posts_per_page',
[
'label'   => esc_html__( 'Number of items to show', 'gmaakeup' ),
'type'    => Controls_Manager::NUMBER,
'default' => 10,
'condition' => [
  'style' => ['style5']  
],
]
);
$this->add_control(
'shortcode',
[
'label' => __( 'Enter your shortcode', 'gmaakeup' ),
'type' => Controls_Manager::TEXTAREA,
'dynamic' => [
'active' => true,
],
'placeholder' => '[gallery id="123" size="medium"]',
'default' => '',
'condition'      => [
'style' => ['style4']
],
]
);
$this->add_responsive_control(
'title_align', [
'label'             =>esc_html__( 'Alignment', 'gmaakeup' ),
'type'             => Controls_Manager::CHOOSE,
'options'         => [
'left'         => [
'title'     =>esc_html__( 'Left', 'gmaakeup' ),
'icon'     => 'fa fa-align-left',
],
'center'     => [
'title'     =>esc_html__( 'Center', 'gmaakeup' ),
'icon'     => 'fa fa-align-center',
],
'right'         => [
'title'     =>esc_html__( 'Right', 'gmaakeup' ),
'icon'     => 'fa fa-align-right',
],
'justify'     => [
'title'     =>esc_html__( 'Justified', 'gmaakeup' ),
'icon'     => 'fa fa-align-justify',
],
],
'default'         => '',
'selectors' => [
'{{WRAPPER}} .inner-item' => 'text-align: {{VALUE}};',
],
]
);
$this->end_controls_section();
}
protected function render( $instance = [] ) {
$settings = $this->get_settings();
$style = $settings[ 'style' ];
$about_backgrund_images = $settings[ 'about_backgrund_images' ];    
$main_img = $settings[ 'main_img' ];    
$icon_image = $settings[ 'icon_image' ];
$text_heading = $settings[ 'text_heading' ];
$sub_heading = $settings[ 'sub_heading' ];
$exp = $settings[ 'exp' ];
$desc_title = $settings[ 'desc_title' ];
$desc_title1 = $settings[ 'desc_title1' ];
$slider_button = $settings[ 'slider_button' ];
$icon = $settings[ 'icon' ];
$button_text = $settings[ 'button_text' ];
$button_link = $settings[ 'button_link' ];
$button_text1 = $settings[ 'button_text1' ];
$button_link1 = $settings[ 'button_link1' ];
$shortcode = $settings[ 'shortcode' ];
$posts_per_page = $settings['posts_per_page'];
$header_video = $settings[ 'header_video' ];
$gal_img_one = $settings[ 'gal_img_one' ];
$gal_img_two = $settings[ 'gal_img_two' ];
$gal_img_three = $settings[ 'gal_img_three' ];

switch ( $style ) {
case 'style1':
require get_template_directory() . '/inc/sections/about/style1.php';
break;
case 'style2':
require get_template_directory() . '/inc/sections/about/style2.php';
break;
case 'style3':
require get_template_directory() . '/inc/sections/about/style3.php';
break;
case 'style4':
require get_template_directory() . '/inc/sections/about/style4.php';
break;
}
}
protected function content_template() {}
public function render_plain_content() {}
}
Plugin::instance()->widgets_manager->register_widget_type( new Elementor_About_Box() );