<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Elementor_Brand_Box extends Widget_Base {

	public function get_name() {
		return 'Elementor-brand-widget';
	}

	public function get_title() {
		return __( 'Zc >  Brand Box' ,'gmaakeup' );
	}

	public function get_icon() {
		
		return 'eicon-icon-box';
	}

	protected function _register_controls() {
		$traits = new \gmaakeup_Elementor_Traits($this);
		
		$this->start_controls_section(
			'services_section',
			['label' => esc_html__( 'Brand','gmaakeup'),]
		);
         $this->add_control(

			'sub_heading',
			[
				'label' => esc_html__( 'Sub Heading' ,'gmaakeup'),
				'type' => Controls_Manager::TEXT,
			]
			);
			
        
        $this->add_control(

			'text_heading',
			[
				'label' => esc_html__( 'Text Heading' ,'gmaakeup'),
				'type' => Controls_Manager::TEXT,
			]
			);
        
		$this->add_control(
			'service_section',
			[
				'label' => esc_html__( 'Repeator Text','gmaakeup'),
				'type' => Controls_Manager::REPEATER,
				'fields' => [
					
					[                    
						'name' => 'logo_img',
						'label' => esc_html__( 'Logo Image' ,'gmaakeup' ),
						'type' => Controls_Manager::MEDIA,
					],
                    
                   
                              
				],
			]
		);
         
		$this->end_controls_section();
	}

	protected function render( $instance = [] ) {

		gmaakeup_el()->get_section('brand', [
            
			'service_section_var' => $this->get_settings('service_section'),
			'sub_heading' => $this->get_settings('sub_heading'),
            'text_heading' => $this->get_settings('text_heading'),
          
			]);
	}

	protected function content_template() {}

	public function render_plain_content() {}

}

Plugin::instance()->widgets_manager->register_widget_type( new Elementor_Brand_Box() );