<?php
namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

class Elementor_portfolio extends Widget_Base
{
	public function get_name()
	{
		return 'Elementor-portfolio-widget';
	}

	public function get_title()
	{
		return __('Zc >  Portfolio', 'gmaakeup');
	}

	public function get_icon()
	{
		return 'eicon-icon-box';
	}

	protected function _register_controls()
	{
		$traits = new \gmaakeup_Elementor_Traits($this);
		$this->start_controls_section('section_tab', ['label' => esc_html__('Portfolio', 'gmaakeup'),]);
        
        
        $this->add_control(

			'back_img',

			[

				'label' => esc_html__( 'Background Image' ,'gmaakeup'),
				'type' => Controls_Manager::MEDIA,
                'condition'      => [
                          'style' =>['style3'],
                        ],
			]

			);
        
        $this->add_control(

			'icon_img',

			[

				'label' => esc_html__( 'Icon Image' ,'gmaakeup'),
				'type' => Controls_Manager::MEDIA,
                'condition'      => [
                          'style' =>['style3'],
                        ],
			]

			);
        $this->add_control(

			'sub_heading',

			[

				'label' => esc_html__( 'Sub Heading' ,'gmaakeup'),
				'type' => Controls_Manager::TEXT,
                'condition'      => [
                        'style' =>['style1','style2'],
                        ],

			]

			);
        $this->add_control(
            'button_text', [
            'label'             =>esc_html__( 'Button Text', 'gmaakeup' ),
            'type'             => Controls_Manager::TEXT,
            'condition'      => [
            'style' =>['style3'],
            ],
            ]
        );
        $this->add_control(
            'button_link', [
            'label'             =>esc_html__( 'Button URL', 'gmaakeup' ),
            'type'             => Controls_Manager::URL,
            'condition'      => [
            'style' => ['style3'],
            ],
            ]
        );
        $this->add_control(

			'text_heading',

			[

				'label' => esc_html__( 'Heading' ,'gmaakeup'),
				'type' => Controls_Manager::TEXT,
                'condition'      => [
                        'style' =>['style1','style3'],
                        ],

			]

			);
        
      
        $this->add_control(
			'posts_per_page',
			[
				'label'   => esc_html__( 'Number of items to show', 'gmaakeup' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 6,
			]
		);
        
        $this->add_control(
			'select_categories',
			[
				'label' => esc_html__( 'Filter by Categories', 'gmaakeup' ),
				'type' => Controls_Manager::SELECT2,
				'options' => gmaakeup_el()->get_terms_dropdown_array([
					'taxonomy' => 'category',
					'hide_empty' => false,
					]),
				'multiple' => true,
			]
		);
        
		$this->add_control(
			'style',
			[
				'type' => Controls_Manager::SELECT, 'label' => esc_html__('Choose Style', 'gmaakeup'), 'default' => 'style1',
				'label_block' => true, 'options' => [
					'style1' => esc_html__('Portfolio Carousel', 'gmaakeup'), 
					'style2' => esc_html__('Portfolio Filter', 'gmaakeup'), 
                    'style3' => esc_html__('Portfolio Normal', 'gmaakeup'),
				],
			]
		);
		$this->end_controls_section();
	}
	protected function render($instance = [])
	{
		$settings = $this->get_settings();
        $back_img = $settings[ 'back_img' ];  
        $icon_img = $settings[ 'icon_img' ];  
        $sub_heading = $settings[ 'sub_heading' ];  
        $text_heading = $settings[ 'text_heading' ];  
        $button_text = $settings[ 'button_text' ];
        $button_link = $settings[ 'button_link' ];
        $posts_per_page = $settings['posts_per_page'];
        $category = $settings['select_categories'];
		$style = $settings['style'];
		switch ($style) {
			case 'style1':
				require get_template_directory() . '/inc/sections/portfolio/style1.php';
				break;
                
            case 'style2':
				require get_template_directory() . '/inc/sections/portfolio/style2.php';
				break;              
          

			case 'style3':
				require get_template_directory() . '/inc/sections/portfolio/style3.php';
				break;
		}
	}
	protected function content_template() {}
    
	public function render_plain_content() {}
}

Plugin::instance()->widgets_manager->register_widget_type(new Elementor_portfolio());
